/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.data.repo;

import com.android.invoice.domain.model.res_invoice.AResInvoiceDtlDto;
import com.dto.restaurant.ResPatternDetailDto;
import com.dto.restaurant.ResPatternDto;
import com.service.SettingLoader;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/invoice/data/repo/ArticleExistUtil;", "", "()V", "checkExistArticleErrors", "", "dtl", "Lcom/android/invoice/domain/model/res_invoice/AResInvoiceDtlDto;", "jdbcTemplate", "Lcom/utility/TncJdbc;", "settingLoader", "Lcom/service/SettingLoader;", "checkStockWithoutPattern", "getCurrentExist", "", "aCode", "", "getPatternDetails", "Lcom/dto/restaurant/ResPatternDto;", "Lorg/springframework/jdbc/core/JdbcTemplate;", "patternId", "", "TNCHolooWebService"})
@SourceDebugExtension(value={"SMAP\nArticleExistUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticleExistUtil.kt\ncom/android/invoice/data/repo/ArticleExistUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class ArticleExistUtil {
    @NotNull
    public static final ArticleExistUtil INSTANCE = new ArticleExistUtil();

    private ArticleExistUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void checkExistArticleErrors(@NotNull AResInvoiceDtlDto dtl, @NotNull TncJdbc jdbcTemplate, @NotNull SettingLoader settingLoader) {
        Intrinsics.checkNotNullParameter((Object)dtl, (String)"dtl");
        Intrinsics.checkNotNullParameter((Object)jdbcTemplate, (String)"jdbcTemplate");
        Intrinsics.checkNotNullParameter((Object)settingLoader, (String)"settingLoader");
        Boolean isPatternEnabled = settingLoader.isRestaurantSellPatternEnabled();
        int patternId = settingLoader.getRestaurantSellPattern();
        Intrinsics.checkNotNull((Object)isPatternEnabled);
        if (isPatternEnabled.booleanValue() && patternId != -1) {
            ResPatternDetailDto resPatternDetailDto;
            ResPatternDetailDto resPatternDetailDto2;
            ResPatternDto resPatternDto = INSTANCE.getPatternDetails((JdbcTemplate)jdbcTemplate, patternId);
            Object object = resPatternDto;
            if (object != null && (object = object.getDetails()) != null) {
                Object v1;
                block6: {
                    Iterable iterable = (Iterable)object;
                    for (Object t : iterable) {
                        ResPatternDetailDto it = (ResPatternDetailDto)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getACode(), (Object)dtl.productId)) continue;
                        v1 = t;
                        break block6;
                    }
                    v1 = null;
                }
                resPatternDetailDto2 = v1;
            } else {
                resPatternDetailDto2 = resPatternDetailDto = null;
            }
            if (resPatternDetailDto != null) {
                if (settingLoader.isAllowSellWithoutPattern()) {
                    return;
                }
                String startTime = settingLoader.getRestaurantStartPatternTime();
                String sqlStr = " SELECT rpd1.MaxSell_Days - (ISNULL(SumFew,0)+ISNULL(SumFewLg,0)) stock \n FROM Res_PatternDetail  Rpd1 LEFT JOIN \n (SELECT SUM(FL_Few) SumFew,A_Code from Res_Facture  F \n INNER JOIN Res_Fac_List FL ON  F.F_Code =FL.F_Code WHERE (( (F.F_Type IN (1,2)) AND \n f.F_Date = CAST(GETDATE() AS DATE) AND CONVERT(TIME, f.F_Time) >= CONVERT(Time, '" + startTime + "')) OR \n ((F.F_Type IN (1,2)) AND F.F_Date = DATEADD(DAY, 1, CAST(GETDATE() AS DATE)) \n AND CONVERT(TIME, f.F_Time) < Convert(Time, '" + startTime + "'))) \n GROUP BY A_Code) S1 on rpd1.A_Code = S1.A_Code LEFT JOIN \n (SELECT sum(FL.Few_Article) SumFewLg, A_Code FROM Res_Factur_Log F \n INNER JOIN Res_FacList_Log FL ON F.Fac_Code = FL.Fac_Code WHERE \n ((f.Fac_Date = CAST(GETDATE() AS DATE) AND CONVERT(TIME, f.Fac_Time) >= Convert(TIME, '" + startTime + "')) \n OR (F.Fac_Date = DATEADD(DAY, 1, CAST(GETDATE() AS DATE)) AND CONVERT(TIME, f.Fac_Time)  < convert(time, '" + startTime + "'))) \n GROUP BY A_Code) Lg ON rpd1.A_Code = lg.A_Code \n WHERE rpd1.Res_PatternId = " + patternId + " AND rpd1.A_Code = '" + dtl.productId + '\'';
                SqlRowSet rowSet = jdbcTemplate.queryForRowSet(sqlStr);
                if (!rowSet.next()) throw new TncException(TncExceptionMessages.DEFAULT_ERROR);
                double sellCount = rowSet.getDouble("stock");
                Double d = dtl.amount;
                Intrinsics.checkNotNullExpressionValue((Object)d, (String)"amount");
                double total = sellCount - ((Number)d).doubleValue();
                if (!(total < 0.0)) return;
                Object[] objectArray = new Object[]{dtl.productName};
                throw new TncException(TncExceptionMessages.NOT_ENOUGH_SOCK.setArgs(objectArray));
            }
            INSTANCE.checkStockWithoutPattern(settingLoader, dtl, jdbcTemplate);
            return;
        }
        INSTANCE.checkStockWithoutPattern(settingLoader, dtl, jdbcTemplate);
    }

    private final void checkStockWithoutPattern(SettingLoader settingLoader, AResInvoiceDtlDto dtl, TncJdbc jdbcTemplate) {
        if (settingLoader.mustHaveStore()) {
            String string = dtl.productId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"productId");
            double exist = this.getCurrentExist(string, jdbcTemplate);
            Double d = dtl.amount;
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"amount");
            if (((Number)d).doubleValue() > exist + dtl.oldAmount) {
                Object[] objectArray = new Object[]{dtl.productName};
                throw new TncException(TncExceptionMessages.NOT_ENOUGH_SOCK.setArgs(objectArray));
            }
        }
    }

    private final double getCurrentExist(String aCode, TncJdbc jdbcTemplate) {
        String sqlStr = "SELECT Exist FROM W_ShowArticleForSearch_Big WHERE a_code='" + aCode + '\'';
        SqlRowSet rowSet = jdbcTemplate.queryForRowSet(sqlStr);
        return rowSet.next() ? rowSet.getDouble("Exist") : 0.0;
    }

    private final ResPatternDto getPatternDetails(JdbcTemplate jdbcTemplate, int patternId) {
        String sqlStr = "SELECT * FROM Res_PatternDetail WHERE Res_PatternId = " + patternId;
        ArrayList arrayList = (ArrayList)jdbcTemplate.query(sqlStr, arg_0 -> ArticleExistUtil.getPatternDetails$lambda$1(patternId, arg_0));
        if (arrayList == null) {
            return null;
        }
        ArrayList details = arrayList;
        sqlStr = "SELECT * FROM Res_Pattern WHERE id = " + patternId;
        return (ResPatternDto)jdbcTemplate.query(sqlStr, arg_0 -> ArticleExistUtil.getPatternDetails$lambda$2(patternId, details, arg_0));
    }

    private static final ArrayList getPatternDetails$lambda$1(int $patternId, ResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        ArrayList<ResPatternDetailDto> list = new ArrayList<ResPatternDetailDto>();
        while (resultSet.next()) {
            int n = resultSet.getInt("id");
            String string = resultSet.getString("A_Code");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            ResPatternDetailDto resPatternDetailDto = new ResPatternDetailDto(n, $patternId, string, resultSet.getInt("MaxSell_Days"));
            list.add(resPatternDetailDto);
        }
        return list;
    }

    private static final ResPatternDto getPatternDetails$lambda$2(int $patternId, ArrayList $details, ResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)$details, (String)"$details");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        if (resultSet.next()) {
            String string = resultSet.getString("P_Name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = resultSet.getString("ModifyDate");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            return new ResPatternDto($patternId, string, string2, (List)$details);
        }
        return null;
    }
}

